// Converted to C and H files by Softools, Inc. DC2ANSI utility - Version 1.7

#include "dcdefs.h"
#include "udpdebug.h"
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <stcpip.h>

/* START FUNCTION DESCRIPTION ********************************************
UDPDbgInit                       <SSCANF.LIB>

SYNTAX: int dbg_init(int ena);

PARAMETER1: 1 to enable, 0 to disable.

KEYWORDS: debug

DESCRIPTION: Initialize UDP debug console Any printf's to
the debugger before sock_init() may cause problems. After sock_init, call dng_init(1).

RETURN VALUE:	integer, non-0 if error.
END DESCRIPTION **********************************************************/

#ifndef DEBUG_UDP_PORT
#define DEBUG_UDP_PORT	2200
#endif

typedef struct {
	char cmd;
	int	parami;
	long	paraml;
	char data[258];
	} DBG_CMD;

#define DEBUG_PING -1
#define DEBUG_ENABLE 0
#define DEBUG_READ 1
#define DEBUG_WRITE 2
#define DEBUG_TEXT 3
#define DEBUG_RFLOAT 4
#define DEBUG_EREAD 5
#define DEBUG_EWRITE 6
#define DEBUG_IREAD 7
#define DEBUG_IWRITE 8

static long _debug_ip=0;
static char _debug_sock_open=0;
static udp_Socket _udp_dbg_sock;
static unsigned int _debug_port;
static char _dbg_input[32];
static char * _dbg_read=_dbg_input;
static char * _dbg_write=_dbg_input;
static char buf[280];
static char dbg_output[256];
static char * output_ptr=dbg_output;
char debug_autocr=1;
//  Local definitions

int _dbg_rx(int c);

FILE debug_stdio[1] = { (__outFunc) debug_putchar, (__inFunc) debug_getchar, 0 };

int debug_init(int ena)
{
	if (!ena)
	{
		if (_debug_sock_open)
			sock_close(&_udp_dbg_sock);
		_debug_sock_open=0;
		_debug_ip=0l;
		return 0;
	}
	if(!udp_extopen(&_udp_dbg_sock, IF_ETH0, DEBUG_UDP_PORT, -1L, -1, NULL, 0, 0))
	{
#if DEBUG_RST
		printf("udp_open failed!\r\n");
#endif
		return -1;
	}
	_debug_sock_open=1;
	return 0;
}


/* START FUNCTION DESCRIPTION ********************************************
dbg_getchar                       <UDPDEBUG.LIB>

SYNTAX: int near dbg_getchar()

PARAMETERS: none

KEYWORDS: debug

DESCRIPTION: Get next char from input
	Will use the DC Stdio window if noe UDP console is connected

RETURN VALUE: charcter pressed

END DESCRIPTION **********************************************************/


/* START FUNCTION DESCRIPTION ********************************************
dbg_kbhit                       <UDPDEBUG.LIB>

SYNTAX: int dbg_kbhit()

PARAMETERS: none

KEYWORDS: debug

DESCRIPTION: Test if character pressed.
	Will use the DC Stdio window if noe UDP console is connected

RETURN VALUE: Returns 1 if character in input buffer, 0 if empty

END DESCRIPTION **********************************************************/

int debug_kbhit(void)
{
	if (_dbg_read!=_dbg_write)
		return 1;
	return 0;
}


int near debug_getchar(void)
{
	int c;
	if (!debug_kbhit())
		return -1;
	c=*_dbg_read++;
	c&=0xff;
	if (_dbg_read>=_dbg_input+32)
		_dbg_read=_dbg_input;
	return c;
}

void near debug_putchar(char c)
{
	if (_debug_ip==0l)
		return;
	if (debug_autocr&&c=='\n')
	    *output_ptr++='\r';
    *output_ptr++=c;
	if (output_ptr>=dbg_output+256)
		debug_tick(); // will clear ptr
}


int _dbg_rx(int c)
{
	char * s;
	s=_dbg_write;
	if (++s==_dbg_input+32)
		s=_dbg_input;
	if (s==_dbg_read) // buffer full
	{
		puts("STDIO Input Buffer Overflow!\r\n");
		return 1;
	}
	*_dbg_write=c;
	_dbg_write=s;
	return 0;
}

/* START FUNCTION DESCRIPTION ********************************************
debug_tick                       <UDPDEBUG.LIB>

SYNTAX: int debug_tick();

PARAMETERS: none

KEYWORDS: debug

DESCRIPTION: Process debug requests

RETURN VALUE:	0 if no packet, 1 if packet processed, -1 if error in data

END DESCRIPTION **********************************************************/

unsigned CRC16(unsigned char * pcdataptr,unsigned uslength,unsigned uscrc)
{
	unsigned usdata;
	if (uslength==0) return(0);
	while(uslength--)
	{
		usdata=(*(pcdataptr++))<<8;
		uscrc=((uscrc&0xff)<<8)+(uscrc>>8);
		uscrc=uscrc^usdata;
		usdata=uscrc& 0xff00;
		usdata<<=4;
		uscrc=uscrc^usdata;
		usdata = uscrc & 0xff00;
		usdata >>= 5;
		uscrc = uscrc ^ usdata;
		usdata >>= 7;
	}
	uscrc = ~(((uscrc & 0x00ff) <<8)+ (uscrc >> 8 ));
	return(uscrc);
}

int debug_tick()
{
	longword ip;
	word port;
	char * s;
	int len,retval;
	unsigned short * crc;
	DBG_CMD * cmd;
	cmd=(DBG_CMD *)buf;
    if (output_ptr!=dbg_output)
	{
		cmd->cmd=DEBUG_TEXT;
		cmd->parami=(output_ptr-dbg_output);
		memcpy(cmd->data,dbg_output,cmd->parami);
		crc=(unsigned short *)&cmd->data[cmd->parami];
		*crc=CRC16(buf+2,sizeof(DBG_CMD)-258+cmd->parami,0xffff);
		udp_sendto(&_udp_dbg_sock,buf,sizeof(DBG_CMD)-256+cmd->parami,_debug_ip,_debug_port);
		output_ptr=dbg_output;
	}
	/* receive the packet */
	tcp_tick(&_udp_dbg_sock);
	len= udp_recvfrom(&_udp_dbg_sock, buf, sizeof(buf),&ip,&port);
	if (-1 ==len)
	{
		/* no packet read. return */
		return 0;
	}
	// check crc
	crc=(unsigned short *)(buf+len-2);
	if (CRC16(buf,len-2,0xffff)!=*crc)
	{
		puts("Debug CRC error\n");
		return -1;
	}
	retval=1;	// default to ok
	switch (cmd->cmd)
	{
	case	DEBUG_PING:	// search
			cmd->parami=0;
			cmd->paraml=0;
			crc=(unsigned short *)cmd->data;
			*crc=CRC16(buf+2,sizeof(DBG_CMD)-258,0xffff);
			udp_sendto(&_udp_dbg_sock,buf,sizeof(DBG_CMD)-256,ip,port);
			break;
	case	DEBUG_ENABLE: // enable/disable
			if (cmd->parami==0)
			{
				_debug_ip=0l;
//				dbg_printf("Connection Closed\n");
			}
			else
			{
				if ((cmd->parami==1)||(_debug_ip!=ip)||(_debug_port!=port))
				{
					_debug_ip=ip;
					_debug_port=port;
					sprintf(dbg_output,"STDIO Connect from %d.%d.%d.%d port %d.\n",0xff&(int)(ip>>24),0xff&(int)(ip>>16),
						0xff&(int)(ip>>8),(int)(ip&0xff),port);
					output_ptr=dbg_output+strlen(dbg_output);
				}
			}
			break;
	case	DEBUG_READ:	// read mem
			if (cmd->parami>256)
				cmd->parami=256;  // maximum length
			len=cmd->parami;
			if (len<=0)
			{
				retval=-1;
				break;		// invalid length
			}
			fmemcpy((void far *)cmd->data,(void far *)cmd->paraml,(len&1)?len+1:len);
			crc=(unsigned short *)&cmd->data[len];
			*crc=CRC16(buf+2,sizeof(DBG_CMD)-258+len,0xffff);
			udp_sendto(&_udp_dbg_sock,buf,sizeof(DBG_CMD)-256+len,ip,port);
			break;
	case	DEBUG_WRITE:	// write mem
			len=cmd->parami;
			if (len>256)
				len=256;
			if (len<=0)
			{
				retval=-1;
				break;		// invalid length
			}
			fmemcpy((void far *)cmd->paraml,(void far *)cmd->data,len);
			break;
	case DEBUG_TEXT:
			if (cmd->parami>32)
				cmd->parami=32;
			if (cmd->parami<=0)
			{
				retval=-1;
				break;		// invalid length
			}
			for (len=0;len<cmd->parami;len++)
				if (_dbg_rx(cmd->data[len]))
					break;
			break;
	case	DEBUG_EREAD:	// read eiomem
			if (cmd->parami>256)
				cmd->parami=256;  // maximum length
			len=cmd->parami;
			if (len<=0)
			{
				retval=-1;
				break;		// invalid length
			}
			s=cmd->data;
			while (len--)
				*s++=ine((int)cmd->paraml++);
			crc=(unsigned short *)&cmd->data[cmd->parami];
			*crc=CRC16(buf+2,sizeof(DBG_CMD)-258+cmd->parami,0xffff);
			udp_sendto(&_udp_dbg_sock,buf,sizeof(DBG_CMD)-256+cmd->parami,ip,port);
			break;
	case	DEBUG_EWRITE:	// write eiomem
			if (cmd->parami>256)
				cmd->parami=256;  // maximum length
			len=cmd->parami;
			if (len<=0)
			{
				retval=-1;
				break;		// invalid length
			}
			s=cmd->data;
			while (len--)
				oute((int)cmd->paraml++,*s++);
			break;
	case	DEBUG_IREAD:	// read eiomem
			if (cmd->parami>256)
				cmd->parami=256;  // maximum length
			len=cmd->parami;
			if (len<=0)
			{
				retval=-1;
				break;		// invalid length
			}
			s=cmd->data;
			while (len--)
				*s++=ini((int)cmd->paraml++);
			crc=(unsigned short *)&cmd->data[cmd->parami];
			*crc=CRC16(buf+2,sizeof(DBG_CMD)-258+len,0xffff);
			udp_sendto(&_udp_dbg_sock,buf,sizeof(DBG_CMD)-256+cmd->parami,ip,port);
			break;
	case	DEBUG_IWRITE:	// write eiomem
			if (cmd->parami>256)
				cmd->parami=256;  // maximum length
			len=cmd->parami;
			if (len<=0)
			{
				retval=-1;
				break;		// invalid length
			}
			s=cmd->data;
			while (len--)
				outi((int)cmd->paraml++,*s++);
			break;
	}
	return retval;
}

